#pragma once

#include <DListView.h>
#include <DIcono.h>

class ListViewEstrellas;

/* Clase que hereda de DListView_Item y tiene como aadido el valor Estrellas */
class ItemEstrellas : public DWL::DListView_Item {
  public :
            ItemEstrellas(const BYTE nEstrellas = 1) : DListView_Item(), Estrellas(nEstrellas), _EstrellasMM(-1)    { };
           ~ItemEstrellas(void)                                                                                     { };
    char    Estrellas;
  protected :
    char   _EstrellasMM;

    friend class ListViewEstrellas;
};

/* Clase que hereda de DListView y muestra una lista con unas estrellas para elegir de 1 a 5 */
class ListViewEstrellas : public DWL::DListView {
  public:
                    ListViewEstrellas(void);
    HWND            Crear(DBaseWnd *nPadre, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID);
    ItemEstrellas  *AgregarItem(const int nIcono, const TCHAR *nTexto, const BYTE nEstrellas);

    LRESULT         Evento_PintarItem(HDC hDC, const UINT nItem, const UINT nSubItem, DWORD nTipoItem);
    LRESULT         Evento_Mouse_Movimiento(const int nItem, const int nSubItem, const int cX, const int cY);
    LRESULT         Evento_Mouse_Click(const int nItem, const int nSubItem, const UINT nBoton, const int cX, const int cY);
    LRESULT         Evento_Mouse_Saliendo(void);
  protected:
    DWL::DIcono    _IconoEstrella;
    DWL::DIcono    _IconoEstrellaPalida;
    int            _UltimoItem;
};
